export const supportedFormatsAr = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "مستند نصي غير منسق.",
    fileType: "نص عادي",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description:
      "تنسيق ملف نصي يستخدم علامات التبويب لفصل القيم وفواصل الأسطر لفصل السجلات.",
    fileType: "قيم مفصولة بعلامات التبويب",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description:
      "تنسيق ملف نصي يستخدم علامات التبويب لفصل القيم وفواصل الأسطر لفصل السجلات.",
    fileType: "قيم مفصولة بعلامات التبويب",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description: "تنسيق ملف نصي يستخدم الفواصل كفاصل بين القيم.",
    fileType: "قيم مفصولة بفواصل",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description:
      "HTML هو لغة ترميز قياسية تُستخدم في هيكلة صفحات الويب والمحتوى.",
    fileType: "لغة ترميز النص الفائق",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description:
      "HTML هو لغة ترميز قياسية تُستخدم في هيكلة صفحات الويب والمحتوى.",
    fileType: "لغة ترميز النص الفائق",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "تنسيق ملف أرشيف صفحة ويب.",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "تنسيق ملف أرشيف صفحة ويب.",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description: "تنسيق ملف يعتمد على XML يستخدم لعروض PowerPoint التقديمية.",
    fileType: "مايكروسوفت باوربوينت",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description: "تنسيق ملف يعتمد على XML يستخدم لجداول بيانات Excel.",
    fileType: "مايكروسوفت إكسل",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description: "تنسيق ملف يعتمد على XML يستخدم لمستندات Word.",
    fileType: "مايكروسوفت وورد",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description: "تنسيق ملف يستخدم لتخزين كائنات رسائل البريد في Outlook.",
    fileType: "مايكروسوفت أوتلوك",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "تنسيق ملف يعتمد على XML يستخدم على نطاق واسع في برامج الترجمة والمحلية.",
    fileType: "تبادل الترجمة والمحلية XML",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "تنسيق ملف يعتمد على XML يستخدم على نطاق واسع في برامج الترجمة والمحلية.",
    fileType: "تبادل الترجمة والمحلية XML",
  },
];

export const supportedFormatsBn = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "একটি অবিন্যস্ত পাঠ্য নথি।",
    fileType: "সাধারণ পাঠ্য",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description:
      "একটি পাঠ্য ফাইল ফরম্যাট যা মানগুলি পৃথক করতে ট্যাব এবং রেকর্ডগুলি পৃথক করতে নতুন লাইন ব্যবহার করে।",
    fileType: "ট্যাব দ্বারা পৃথক মান",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description:
      "একটি পাঠ্য ফাইল ফরম্যাট যা মানগুলি পৃথক করতে ট্যাব এবং রেকর্ডগুলি পৃথক করতে নতুন লাইন ব্যবহার করে।",
    fileType: "ট্যাব দ্বারা পৃথক মান",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description:
      "একটি পাঠ্য ফাইল ফরম্যাট যা মানগুলির মধ্যে ডিলিমিটার হিসাবে কমা ব্যবহার করে।",
    fileType: "কমা দ্বারা পৃথক মান",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description:
      "HTML একটি মানক মার্কআপ ভাষা যা ওয়েব পৃষ্ঠাগুলি এবং বিষয়বস্তু গঠনে ব্যবহৃত হয়।",
    fileType: "হাইপারটেক্সট মার্কআপ ল্যাঙ্গুয়েজ",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description:
      "HTML একটি মানক মার্কআপ ভাষা যা ওয়েব পৃষ্ঠাগুলি এবং বিষয়বস্তু গঠনে ব্যবহৃত হয়।",
    fileType: "হাইপারটেক্সট মার্কআপ ল্যাঙ্গুয়েজ",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "একটি ওয়েব পৃষ্ঠা সংরক্ষণাগার ফাইল ফরম্যাট।",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "একটি ওয়েব পৃষ্ঠা সংরক্ষণাগার ফাইল ফরম্যাট।",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description:
      "একটি XML-ভিত্তিক ফাইল ফরম্যাট যা PowerPoint স্লাইডশো উপস্থাপনাগুলির জন্য ব্যবহৃত হয়।",
    fileType: "মাইক্রোসফ্ট পাওয়ারপয়েন্ট",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description:
      "একটি XML-ভিত্তিক ফাইল ফরম্যাট যা Excel স্প্রেডশীটের জন্য ব্যবহৃত হয়।",
    fileType: "মাইক্রোসফ্ট এক্সেল",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description: "একটি XML-ভিত্তিক ফাইল ফরম্যাট যা Word নথির জন্য ব্যবহৃত হয়।",
    fileType: "মাইক্রোসফ্ট ওয়ার্ড",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description:
      "একটি ফাইল ফরম্যাট যা সংরক্ষিত Outlook মেল বার্তা অবজেক্টের জন্য ব্যবহৃত হয়।",
    fileType: "মাইক্রোসফ্ট আউটলুক",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "একটি মানসম্মত XML-ভিত্তিক ফাইল ফরম্যাট যা অনুবাদ এবং লোকালাইজেশন সফ্টওয়্যার প্রক্রিয়াকরণের জন্য ব্যাপকভাবে ব্যবহৃত হয়।",
    fileType: "XML লোকালাইজেশন বিনিময়",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "একটি মানসম্মত XML-ভিত্তিক ফাইল ফরম্যাট যা অনুবাদ এবং লোকালাইজেশন সফ্টওয়্যার প্রক্রিয়াকরণের জন্য ব্যাপকভাবে ব্যবহৃত হয়।",
    fileType: "XML লোকালাইজেশন বিনিময়",
  },
];

export const supportedFormatsDe = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "Ein unformatiertes Textdokument.",
    fileType: "Klartext",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description:
      "Ein Textdateiformat, das Tabs verwendet, um Werte zu trennen, und Zeilenumbrüche, um Datensätze zu trennen.",
    fileType: "Tabulatorgetrennte Werte",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description:
      "Ein Textdateiformat, das Tabs verwendet, um Werte zu trennen, und Zeilenumbrüche, um Datensätze zu trennen.",
    fileType: "Tabulatorgetrennte Werte",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description:
      "Ein Textdateiformat, das Kommas als Trennzeichen zwischen Werten verwendet.",
    fileType: "Kommagetrennte Werte",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description:
      "HTML ist eine standardisierte Auszeichnungssprache, die zur Strukturierung von Webseiten und Inhalten verwendet wird.",
    fileType: "HyperText Markup Language",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description:
      "HTML ist eine standardisierte Auszeichnungssprache, die zur Strukturierung von Webseiten und Inhalten verwendet wird.",
    fileType: "HyperText Markup Language",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "Ein Archivdateiformat für Webseiten.",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "Ein Archivdateiformat für Webseiten.",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description:
      "Ein XML-basiertes Dateiformat, das für PowerPoint-Präsentationen verwendet wird.",
    fileType: "Microsoft PowerPoint",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description:
      "Ein XML-basiertes Dateiformat, das für Excel-Tabellen verwendet wird.",
    fileType: "Microsoft Excel",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description:
      "Ein XML-basiertes Dateiformat, das für Word-Dokumente verwendet wird.",
    fileType: "Microsoft Word",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description:
      "Ein Dateiformat, das für gespeicherte Outlook-Mailnachrichtenobjekte verwendet wird.",
    fileType: "Microsoft Outlook",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "Ein standardisiertes, XML-basiertes Dateiformat, das in Übersetzungs- und Lokalisierungssoftware weit verbreitet ist.",
    fileType: "XML-Lokalisierungsinterchange",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "Ein standardisiertes, XML-basiertes Dateiformat, das in Übersetzungs- und Lokalisierungssoftware weit verbreitet ist.",
    fileType: "XML-Lokalisierungsinterchange",
  },
];

export const supportedFormatsEs = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "Un documento de texto sin formato.",
    fileType: "Texto sin formato",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description:
      "Un formato de archivo de texto que utiliza tabulaciones para separar valores y saltos de línea para separar registros.",
    fileType: "Valores separados por tabulaciones",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description:
      "Un formato de archivo de texto que utiliza tabulaciones para separar valores y saltos de línea para separar registros.",
    fileType: "Valores separados por tabulaciones",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description:
      "Un formato de archivo de texto que utiliza comas como delimitador entre valores.",
    fileType: "Valores separados por comas",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description:
      "HTML es un lenguaje de marcado estándar utilizado para estructurar páginas web y contenido.",
    fileType: "Lenguaje de marcado de hipertexto",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description:
      "HTML es un lenguaje de marcado estándar utilizado para estructurar páginas web y contenido.",
    fileType: "Lenguaje de marcado de hipertexto",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "Un formato de archivo de archivo de página web.",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "Un formato de archivo de archivo de página web.",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description:
      "Un formato de archivo basado en XML utilizado para presentaciones de diapositivas de PowerPoint.",
    fileType: "Microsoft PowerPoint",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description:
      "Un formato de archivo basado en XML utilizado para hojas de cálculo de Excel.",
    fileType: "Microsoft Excel",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description:
      "Un formato de archivo basado en XML utilizado para documentos de Word.",
    fileType: "Microsoft Word",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description:
      "Un formato de archivo utilizado para almacenar objetos de mensajes de correo de Outlook.",
    fileType: "Microsoft Outlook",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "Un formato de archivo basado en XML estandarizado ampliamente utilizado en el procesamiento de software de traducción y localización.",
    fileType: "Intercambio de localización XML",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "Un formato de archivo basado en XML estandarizado ampliamente utilizado en el procesamiento de software de traducción y localización.",
    fileType: "Intercambio de localización XML",
  },
];

export const supportedFormatsFr = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "Un document texte non formaté.",
    fileType: "Texte brut",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description:
      "Un format de fichier texte qui utilise des tabulations pour séparer les valeurs et des sauts de ligne pour séparer les enregistrements.",
    fileType: "Valeurs séparées par des tabulations",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description:
      "Un format de fichier texte qui utilise des tabulations pour séparer les valeurs et des sauts de ligne pour séparer les enregistrements.",
    fileType: "Valeurs séparées par des tabulations",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description:
      "Un format de fichier texte qui utilise des virgules comme séparateur entre les valeurs.",
    fileType: "Valeurs séparées par des virgules",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description:
      "HTML est un langage de balisage standard utilisé pour structurer les pages web et le contenu.",
    fileType: "Langage de balisage hypertexte",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description:
      "HTML est un langage de balisage standard utilisé pour structurer les pages web et le contenu.",
    fileType: "Langage de balisage hypertexte",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "Un format de fichier d'archive de page web.",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "Un format de fichier d'archive de page web.",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description:
      "Un format de fichier basé sur XML utilisé pour les présentations PowerPoint.",
    fileType: "Microsoft PowerPoint",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description:
      "Un format de fichier basé sur XML utilisé pour les feuilles de calcul Excel.",
    fileType: "Microsoft Excel",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description:
      "Un format de fichier basé sur XML utilisé pour les documents Word.",
    fileType: "Microsoft Word",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description:
      "Un format de fichier utilisé pour stocker des objets de messages électroniques Outlook.",
    fileType: "Microsoft Outlook",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "Un format de fichier standardisé basé sur XML, largement utilisé dans les logiciels de traduction et de localisation.",
    fileType: "Échange de localisation XML",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "Un format de fichier standardisé basé sur XML, largement utilisé dans les logiciels de traduction et de localisation.",
    fileType: "Échange de localisation XML",
  },
];

export const supportedFormatsHi = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "एक अप्रारूपित पाठ दस्तावेज़।",
    fileType: "सादा पाठ",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description:
      "एक पाठ फ़ाइल प्रारूप जो मानों को अलग करने के लिए टैब और रिकॉर्ड को अलग करने के लिए नई पंक्तियों का उपयोग करता है।",
    fileType: "टैब द्वारा विभाजित मान",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description:
      "एक पाठ फ़ाइल प्रारूप जो मानों को अलग करने के लिए टैब और रिकॉर्ड को अलग करने के लिए नई पंक्तियों का उपयोग करता है।",
    fileType: "टैब द्वारा विभाजित मान",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description:
      "एक पाठ फ़ाइल प्रारूप जो मानों के बीच सीमांकक के रूप में अल्पविराम का उपयोग करता है।",
    fileType: "अल्पविराम द्वारा विभाजित मान",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description:
      "HTML एक मानक मार्कअप भाषा है जिसका उपयोग वेब पृष्ठों और सामग्री की संरचना के लिए किया जाता है।",
    fileType: "हाइपरटेक्स्ट मार्कअप लैंग्वेज",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description:
      "HTML एक मानक मार्कअप भाषा है जिसका उपयोग वेब पृष्ठों और सामग्री की संरचना के लिए किया जाता है।",
    fileType: "हाइपरटेक्स्ट मार्कअप लैंग्वेज",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "एक वेब पृष्ठ अभिलेखागार फ़ाइल प्रारूप।",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "एक वेब पृष्ठ अभिलेखागार फ़ाइल प्रारूप।",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description:
      "एक XML-आधारित फ़ाइल प्रारूप जिसका उपयोग PowerPoint स्लाइडशो प्रस्तुतियों के लिए किया जाता है।",
    fileType: "माइक्रोसॉफ्ट पॉवरपॉइंट",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description:
      "एक XML-आधारित फ़ाइल प्रारूप जिसका उपयोग Excel स्प्रेडशीट्स के लिए किया जाता है।",
    fileType: "माइक्रोसॉफ्ट एक्सेल",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description:
      "एक XML-आधारित फ़ाइल प्रारूप जिसका उपयोग Word दस्तावेज़ों के लिए किया जाता है।",
    fileType: "माइक्रोसॉफ्ट वर्ड",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description:
      "एक फ़ाइल प्रारूप जिसका उपयोग संग्रहीत Outlook मेल संदेश वस्तुओं के लिए किया जाता है।",
    fileType: "माइक्रोसॉफ्ट आउटलुक",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "एक मानकीकृत XML-आधारित फ़ाइल प्रारूप जो अनुवाद और स्थानीयकरण सॉफ़्टवेयर प्रसंस्करण में व्यापक रूप से उपयोग किया जाता है।",
    fileType: "XML स्थानीयकरण इंटरचेंज",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "एक मानकीकृत XML-आधारित फ़ाइल प्रारूप जो अनुवाद और स्थानीयकरण सॉफ़्टवेयर प्रसंस्करण में व्यापक रूप से उपयोग किया जाता है।",
    fileType: "XML स्थानीयकरण इंटरचेंज",
  },
];

export const supportedFormatsJa = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "フォーマットされていないテキストドキュメント。",
    fileType: "プレーンテキスト",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description:
      "タブを使用して値を区切り、新しい行でレコードを区切るテキストファイル形式。",
    fileType: "タブ区切り値",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description:
      "タブを使用して値を区切り、新しい行でレコードを区切るテキストファイル形式。",
    fileType: "タブ区切り値",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description: "カンマを区切り文字として使用するテキストファイル形式。",
    fileType: "カンマ区切り値",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description:
      "HTMLは、Webページとコンテンツを構築するために使用される標準的なマークアップ言語です。",
    fileType: "ハイパーテキストマークアップ言語",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description:
      "HTMLは、Webページとコンテンツを構築するために使用される標準的なマークアップ言語です。",
    fileType: "ハイパーテキストマークアップ言語",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "Webページアーカイブファイル形式。",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "Webページアーカイブファイル形式。",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description:
      "PowerPointスライドショープレゼンテーションに使用されるXMLベースのファイル形式。",
    fileType: "Microsoft PowerPoint",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description: "Excelスプレッドシートに使用されるXMLベースのファイル形式。",
    fileType: "Microsoft Excel",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description: "Wordドキュメントに使用されるXMLベースのファイル形式。",
    fileType: "Microsoft Word",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description:
      "Outlookメールメッセージオブジェクトを保存するために使用されるファイル形式。",
    fileType: "Microsoft Outlook",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "翻訳およびローカリゼーションソフトウェア処理で広く使用される標準化されたXMLベースのファイル形式。",
    fileType: "XMLローカリゼーションインターチェンジ",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "翻訳およびローカリゼーションソフトウェア処理で広く使用される標準化されたXMLベースのファイル形式。",
    fileType: "XMLローカリゼーションインターチェンジ",
  },
];

export const supportedFormatsPt = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "Um documento de texto não formatado.",
    fileType: "Texto Simples",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description:
      "Um formato de arquivo de texto que usa tabulações para separar valores e quebras de linha para separar registros.",
    fileType: "Valores Separados por Tabulação",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description:
      "Um formato de arquivo de texto que usa tabulações para separar valores e quebras de linha para separar registros.",
    fileType: "Valores Separados por Tabulação",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description:
      "Um formato de arquivo de texto que usa vírgulas como delimitador entre valores.",
    fileType: "Valores Separados por Vírgula",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description:
      "HTML é uma linguagem de marcação padrão usada para estruturar páginas da web e conteúdo.",
    fileType: "Linguagem de Marcação de Hipertexto",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description:
      "HTML é uma linguagem de marcação padrão usada para estruturar páginas da web e conteúdo.",
    fileType: "Linguagem de Marcação de Hipertexto",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "Um formato de arquivo de arquivamento de página da web.",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "Um formato de arquivo de arquivamento de página da web.",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description:
      "Um formato de arquivo baseado em XML usado para apresentações de slides do PowerPoint.",
    fileType: "Microsoft PowerPoint",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description:
      "Um formato de arquivo baseado em XML usado para planilhas do Excel.",
    fileType: "Microsoft Excel",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description:
      "Um formato de arquivo baseado em XML usado para documentos do Word.",
    fileType: "Microsoft Word",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description:
      "Um formato de arquivo usado para armazenar objetos de mensagens de e-mail do Outlook.",
    fileType: "Microsoft Outlook",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "Um formato de arquivo baseado em XML padronizado amplamente usado no processamento de software de tradução e localização.",
    fileType: "Intercâmbio de Localização XML",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "Um formato de arquivo baseado em XML padronizado amplamente usado no processamento de software de tradução e localização.",
    fileType: "Intercâmbio de Localização XML",
  },
];

export const supportedFormatsRu = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "Неотформатированный текстовый документ.",
    fileType: "Простой текст",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description:
      "Формат текстового файла, который использует табуляцию для разделения значений и переносы строк для разделения записей.",
    fileType: "Значения, разделенные табуляцией",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description:
      "Формат текстового файла, который использует табуляцию для разделения значений и переносы строк для разделения записей.",
    fileType: "Значения, разделенные табуляцией",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description:
      "Формат текстового файла, который использует запятые в качестве разделителя между значениями.",
    fileType: "Значения, разделенные запятыми",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description:
      "HTML - это стандартный язык разметки, используемый для структурирования веб-страниц и контента.",
    fileType: "Язык разметки гипертекста",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description:
      "HTML - это стандартный язык разметки, используемый для структурирования веб-страниц и контента.",
    fileType: "Язык разметки гипертекста",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "Формат файла архива веб-страниц.",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "Формат файла архива веб-страниц.",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description:
      "Формат файла на основе XML, используемый для презентаций PowerPoint.",
    fileType: "Microsoft PowerPoint",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description:
      "Формат файла на основе XML, используемый для электронных таблиц Excel.",
    fileType: "Microsoft Excel",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description:
      "Формат файла на основе XML, используемый для документов Word.",
    fileType: "Microsoft Word",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description:
      "Формат файла, используемый для хранения объектов сообщений электронной почты Outlook.",
    fileType: "Microsoft Outlook",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "Стандартизированный формат файла на основе XML, широко используемый в программном обеспечении для перевода и локализации.",
    fileType: "Интерчейндж локализации XML",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "Стандартизированный формат файла на основе XML, широко используемый в программном обеспечении для перевода и локализации.",
    fileType: "Интерчейндж локализации XML",
  },
];

export const supportedFormatsZh = [
  {
    extension: ".txt",
    mimeType: "text/plain",
    description: "未格式化的文本文件。",
    fileType: "纯文本",
  },
  {
    extension: ".txv",
    mimeType: "text/tab-separated-values",
    description: "一种使用制表符分隔值并使用换行符分隔记录的文本文件格式。",
    fileType: "制表符分隔值",
  },
  {
    extension: ".tab",
    mimeType: "text/tab-separated-values",
    description: "一种使用制表符分隔值并使用换行符分隔记录的文本文件格式。",
    fileType: "制表符分隔值",
  },
  {
    extension: ".csv",
    mimeType: "text/csv",
    description: "一种使用逗号作为值之间的分隔符的文本文件格式。",
    fileType: "逗号分隔值",
  },
  {
    extension: ".html",
    mimeType: "text/html",
    description: "HTML是一种用于构建网页和内容的标准标记语言。",
    fileType: "超文本标记语言",
  },
  {
    extension: ".htm",
    mimeType: "text/html",
    description: "HTML是一种用于构建网页和内容的标准标记语言。",
    fileType: "超文本标记语言",
  },
  {
    extension: ".mthml",
    mimeType: "message/rfc822",
    description: "网页存档文件格式。",
    fileType: "MHTML",
  },
  {
    extension: ".mht",
    mimeType: "application/x-mimearchive",
    description: "网页存档文件格式。",
    fileType: "MHTML",
  },
  {
    extension: ".pptx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.presentationml.presentation",
    description: "一种基于XML的文件格式，用于PowerPoint幻灯片演示文稿。",
    fileType: "Microsoft PowerPoint",
  },
  {
    extension: ".xlsx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
    description: "一种基于XML的文件格式，用于Excel电子表格。",
    fileType: "Microsoft Excel",
  },
  {
    extension: ".docx",
    mimeType:
      "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
    description: "一种基于XML的文件格式，用于Word文档。",
    fileType: "Microsoft Word",
  },
  {
    extension: ".msg",
    mimeType: "application/vnd.ms-outlook",
    description: "用于存储Outlook邮件消息对象的文件格式。",
    fileType: "Microsoft Outlook",
  },
  {
    extension: ".xlf",
    mimeType: "application/xliff+xml",
    description:
      "一种标准化的基于XML的文件格式，广泛用于翻译和本地化软件处理中。",
    fileType: "XML本地化交换",
  },
  {
    extension: ".xliff",
    mimeType: "application/xliff+xml",
    description:
      "一种标准化的基于XML的文件格式，广泛用于翻译和本地化软件处理中。",
    fileType: "XML本地化交换",
  },
];
